#include common_scripts\utility;
#include maps\mp\_utility;
#include maps\mp\gametypes\_hud_util;
init()
{
	//level.flagFXBase = loadfx( maps\mp\gametypes\_teams::getTeamFlagFX( "axis" ) );
	level.flagFX = "h1_flag_mp_domination_usmc_blue";
	level.captureFlag = "waypoint_capture_flag";
	level.onPlayerKilled = ::onPlayerKilled;
	level.flareFX = loadfx( "misc/flare_ambient" );
	//level.lift_fx = loadfx( maps\mp\gametypes\_teams::getTeamFlagFX( "allies" ) );
	precacheModel( level.flagFX );
	precacheShader( level.captureFlag );
	level.game_started = false;
	level.match_has_started = false;
	level.flag_picked_up = false;
	level.flag_owner = undefined;
	level thread onPlayerConnect();
	level thread onPlayerDisconnect();
}
onPlayerConnect()
{
	for(;;)
	{
		level waittill( "connected", player );
		player.id = player getName();
		player thread onPlayerSpawn();
	}
}

onPlayerDisconnect()
{
	for(;;)
	{
		level waittill( "disconnected", player );
		if(isDefined(level.flag_owner) && level.flag_owner == player && level.flag_picked_up)
		{
			player detach( level.flagFX, "tag_origin");
			player.score_text.glowColor = (1,0,0);
			level.flagorigin = player.origin;
			level.FXBase = spawnFx(level.flagFXBase, level.flagorigin);
			level.FXFlag = spawn( "script_model", level.flagorigin);
			level.FXFlag setModel( level.flagFX );
			triggerFX(level.FXBase);
			level.flag_picked_up = false;
			level.flag_owner = undefined;
			updatePoints();
		}
	}
}
onPlayerSpawn()
{
	self endon( "disconnect" );
	self pointSystem();
	for(;;)
	{
		self waittill( "spawned_player" );
		self thread setClass();
		if(!level.match_has_started)
		{
			level.match_has_started = true;
			level thread configureDefaults();
		}
	}
}
setClass()
{
	self takeAllWeapons();
	self _clearPerks();
	self setClientDvar("lowAmmoWarningNoAmmoColor2",0.8);
	self setClientDvar("lowAmmoWarningNoAmmoColor1",1);
	self setlethalweapon("iw9_throwknife_mp");
	self maps\mp\gametypes\_class::giveoffhand("iw9_throwknife_mp");
	self setWeaponAmmoClip("iw9_throwknife_mp", 1);
	self giveWeapon( "h2_karambit_mp", 0, false );
	maps\mp\_utility::givePerk("specialty_longersprint");
	maps\mp\_utility::givePerk("specialty_fastmantle");
	maps\mp\_utility::givePerk("specialty_falldamage");
	wait 0.01;
	if(level.game_started) 
		self thread monitorWeapons();
	self switchToWeapon( "h2_karambit_mp" );
	self thread maps\mp\gametypes\_menus::addToTeam( "axis" );
}
pointSystem()
{
	offset = 35;
	self.flag_points = 0;
	self.point_text = self createFontString("default", 1.4);
	self.point_text setPos("left_adjustable", "top_adjustable", "left", "middle", 160-offset, 25);
	self.point_text.hideWhenInMenu = true;
	self.point_text.archived = false;
	self.point_text.glowAlpha = 0.5;
	self.point_text.glowColor = (0,0,0);
	self.score_text = self createFontString("default", 1.4);
	self.score_text setPos("left_adjustable", "top_adjustable", "left", "middle", 270-offset, 25);
	self.score_text.hideWhenInMenu = true;
	self.score_text.archived = false;
	self.score_text.glowAlpha = 0.5;
	self.score_text.glowColor = (1,0,0);
	self.score_text setValue( self.flag_points );
	if(!isDefined(level.flag_owner)) 
		self.point_text setText( "Your Points: \nFlag Owner: N/A" );
	else 
		self.point_text setText( "Your Points: \nFlag Owner: " + level.flag_owner.id );
}
monitorWeapons()
{
	self notify("monitorLoop");
	self endon("death");
	self endon("monitorLoop");
	for(;;)
	{
		if(!isDefined(level.flag_owner))
		{
			if(self getCurrentWeapon() != "h2_karambit_mp")
			{
				self takeWeapon( self getCurrentWeapon() );
				self switchToWeapon( "h2_karambit_mp" );
			}
		}
		else if(isDefined(level.flag_owner) && level.flag_owner != self)
		{
			if(self getCurrentWeapon() != "h2_karambit_mp")
			{
				self takeWeapon( self getCurrentWeapon() );
				self switchToWeapon( "h2_karambit_mp" );
			}
		}
		else if(isDefined(level.flag_owner) && level.flag_owner == self)
		{
			if(self getCurrentWeapon() != "h2_icepick_mp")
			{
				self takeWeapon( self getCurrentWeapon() );
				self switchToWeapon( "h2_icepick_mp" );
			}
		}
		wait 0.01;
	}
}
configureDefaults()
{
	if(!level.game_started)
	{
		gameFlagWait( "prematch_done" );
		level.game_started = true;
		foreach(p in level.players){
			p thread setClass();
		}
	}
	level notify( "flag_reset" );
	playSoundOnPlayers( "mp_obj_captured" );

	
	//level.mapcenter = getCenter();

	randomFlag = getEntArray( "flag_primary", "targetname" );
	level.mapcenter = randomFlag[randomInt(randomFlag.size)].origin;
	level.FXBase = spawnFx(level.flagFXBase, level.mapcenter);
	level.FXFlag = spawn( "script_model", level.mapcenter);
	level.FXFlag setModel( level.flagFX );
	triggerFX(level.FXBase);
	level.flagorigin = level.mapcenter;
	Objective_Delete( 1 );
	Objective_Add( 1, "active");
	Objective_Position( 1, level.flagorigin );
	level thread monitorPickup();
}
monitorPickup()
{
	level endon( "flag_reset" );
	level endon( "game_end" );
	flag_timeout = 0;
	flag_timer = 0;
	for(;;)
	{
		if(!level.flag_picked_up)
		{
			flag_timer = 0;
			if(distance(level.flagorigin,level.mapcenter) >= 5) //flag not at spawn
			{
				flag_timeout++;
				if(flag_timeout >= 500)
				{
					level.FXBase delete();
					level.FXFlag delete();
					level.flag_picked_up = false;
					level.flag_owner = undefined;
					level thread configureDefaults();
				}
			}
			level.flag_playerOn = 0;
			foreach(player in level.players)
			{
				radius = distance(player.origin, level.flagorigin);
				if(radius <= 50 && isAlive(player) && player.pers["team"] == "axis")
				{
					level.flag_playersOn++;
					close_ent = undefined;
					if(level.flag_playersOn > 1)
					{
						close_ent = getClosestEnt( level.flagorigin, level.players );
					}
					else
					{
						close_ent = player;
					}
					playSoundOnPlayers( "mp_war_objective_taken" );
					close_ent attach(level.flagFX, "tag_origin", true);
					level.FXBase delete();
					level.FXFlag delete();
					level.flag_picked_up = true;
					level.flag_owner = close_ent;
					level.flag_owner.name = close_ent.name;
					close_ent.flag_points++;
					if(level.players.size <= 5) speed = 1.2;
					else speed = 1.3;
					close_ent.moveSpeedScaler = speed;
					close_ent setMoveSpeedScale(close_ent.moveSpeedScaler);
					close_ent takeWeapon( "h2_karambit_mp" );
					close_ent giveWeapon( "h2_icepick_mp" );
					//close_ent playsound("NS_mp_cmd_regroup");
					wait 0.01;
					close_ent switchToWeapon( "h2_icepick_mp" );
					close_ent maps\mp\gametypes\_menus::addToTeam( "allies" );
					leaderDialog( "enemy_flag_captured", "allies", "status" );
					Objective_Delete( 1 );
					Objective_Add( 1, "active");
					Objective_Position( 1, level.flagorigin );
					game["teamScores"]["axis"] = 0;
					setTeamScore( "axis", 0 );
					game["teamScores"]["allies"] = 0;
					setTeamScore( "allies", 0 );
					updatePoints();
					checkPoints();
				}
				else
				{
					if(level.flag_playersOn > 0) level.flag_playersOn--;
				}
			}
		}
		else if(level.flag_picked_up)
		{
			flag_timer++;
			foreach(player in level.players)
			{
				if(player == level.flag_owner)
				{
					Objective_Delete( 1 );
					Objective_Add( 1, "active");
					Objective_Position( 1, player.origin );
				}
				if(player == level.flag_owner && flag_timer >= 20)
				{
					flag_timer = 0;
					player.flag_points++;
					score = player.flag_points;
					game["teamScores"]["allies"] = score;
					setTeamScore( "allies", score );
					updateScore();
					checkPoints();
				}
			}
		}
		wait 0.01;
	}
}
checkPoints()
{
	foreach(player in level.players)
	{
		if(player.flag_points >= 100)
		{
			level.finalKillCam_winner = "allies";
			level thread maps\mp\gametypes\_gamelogic::endGame( "allies", "You are the KING!" );
			level thread maps\mp\gametypes\_gamelogic::endGame( "axies", player.id + " is the king of the hill!" );
			level notify("game_end");
		}
	}
}
updatePoints()
{
	self endon( "point_notify" );
	foreach(player in level.players)
	{
		if(!isDefined(level.flag_owner)) 
			player.point_text setText( "Your Points: \nFlag Owner: N/A" );
		else 
			player.point_text setText( "Your Points: \nFlag Owner: " + level.flag_owner.name );
	}
}
updateScore()
{
	self endon( "point_notify" );
	foreach(player in level.players)
	{
		player.score_text setValue( player.flag_points );
		player.score = player.flag_points;
		if(isDefined(level.flag_owner) && player == level.flag_owner) player.score_text.glowColor = (0,1,0);
		else player.score_text.glowColor = (1,0,0);
	}
}
getCenter()
{
	switch(getDvar("mapname"))
	{
		case "mp_afghan": return (2329.7, 944.525, 32.4618);
		case "mp_derail": return (1283.96, 20.9455, 134.499);
		case "mp_estate": return (-1128.58, 1998.73, -185.135);
		case "mp_favela": return (-113.938, 872.349, 152.908);
		case "mp_highrise": return (-1125.28, 6459.13, 2785.03);
		case "mp_invasion": return (-1143.15, -2297.77, 275.599);
		case "mp_checkpoint": return (171.652, 71.4938, 43.4293);
		case "mp_quarry": return (-3971.89, 679.681, -315.667);
		case "mp_rundown": return (441.498, -527.639, 14.484);
		case "mp_rust": return (581.119, 970.193, -197.999);
		case "mp_boneyard": return (172.219, 371.802, -111.799);
		case "mp_nightshift": return (-136.494, -739.289, 7.4766);
		case "mp_subbase": return (133.183, -641.018, 91.5424);
		case "mp_terminal": return (1098.65, 4220.76, 48.5756);
		case "mp_underpass": return (1392.2, 702.058, 371.479);
		case "mp_brecourt": return (872.46, -852.891, -50.9071);
		default: return (0,0,0);
	}
}
onPlayerKilled( eInflictor, attacker, iDamage, sMeansOfDeath, sWeapon, vDir, sHitLoc, psOffsetTime, deathAnimDuration, lifeId )
{
	if(level.flag_picked_up)
	{
		if(self == level.flag_owner && self.pers["team"] == "allies") 
			self detachFlag();
	}
}
detachFlag()
{
	self detach( level.flagFX, "tag_origin");
	self.score_text.glowColor = (1,0,0);
	level.flagorigin = self.origin;
	level.FXBase = spawnFx(level.flagFXBase, level.flagorigin);
	level.FXFlag = spawn( "script_model", level.flagorigin);
	level.FXFlag setModel( level.flagFX );
	triggerFX(level.FXBase);
	level.flag_picked_up = false;
	level.flag_owner = undefined;
	updatePoints();
	self maps\mp\gametypes\_menus::addToTeam( "axis" );
	//self sayall("shit i died");
}
getClosestEnt( org, array )
{
	if ( array.size < 1 ) return;
	dist = 1000000;
	ent = undefined;
	for ( i = 0;i < array.size;i++ )
	{
		newdist = distance( array[ i ] getorigin(), org );
		if ( newdist >= dist ) continue;
		if ( !isAlive(array[ i ] ) && isPlayer( array[ i ] ) ) continue;
		dist = newdist;
		ent = array[ i ];
	}
	return ent;
}
doNewsBar(text, time)
{
	self endon("disconnect");
	bar = self createBar((0,0,0), 800, 25);
	bar setPos( "FULLSCREEN", "bottom_adjustable", "FULLSCREEN", "middle", 0, -8);
	bar.foreGround = true;
	bar.alpha = 0.9;
	txt = self createFontString("default", 1.5);
	txt.foreGround = true;
	txt setText(text);
	for(;;)
	{
		txt setPos("left_adjustable", "bottom_adjustable", "left", "middle", 1000, -8);
		txt moveOverTime( time );
		txt setPos("left_adjustable", "bottom_adjustable", "left", "middle", -1000, -10);
		wait time;
	}
}
setPos( horz, vert, ax, ay, x, y )
{
	self.horzAlign = horz;
	self.vertAlign = vert;
	self.alignX = ax;
	self.alignY = ay;
	self.x = x;
	self.y = y;
}
getName()
{
	nT=getSubStr(self.name,0,self.name.size);
	for (i=0;i<nT.size;i++)
	{
		if (nT[i]=="]") break;
	}
	if (nT.size!=i) nT=getSubStr(nT,i+1,nT.size);
	return nT;
}
map_edits()
{
	map = getDvar("mapname");
	if(map == "mp_rust")
		level thread createLift((381.015, 1071.7, -225.544), 250);
}

createLift(pos,height)
{
//base = spawnFx( level.lift_fx, pos);
//triggerFX(base);
	for(;;)
	{
		foreach(player in level.players)
		{
			if(Distance2d(pos, player.origin) <= 50)
			{	
				player setOrigin(pos);
				wait 0.01;
				playerAngles = player getplayerangles();
				playerVelocity = player getVelocity();
				player setvelocity( (playerVelocity[0], playerVelocity[1], playerVelocity[2]/2 ) + anglestoforward( (270, playerAngles[1], playerAngles[2]) ) * 65 * ( 4 * (height/50) ));
				player playsound("weap_cobra_missile_fire");
				wait 3;
			}
		}
		wait 1;
	}
}